/* Programme de copie de sauvegardes multiples.
Programmé par Maniack Crudelis.
http://www.crudelis.fr
Pour des questions, remarques, suggestions et le support. Rendez-vous sur le forum du site.
Version 1.1.*/
/*Copyright (c) 2008 Hervé Cottin.

Copies de sauvegarde est un logiciel libre; vous pouvez le redistribuer et/ou le modifier selon les termes de la GNU General Public License (Licence Publique Générale GNU) telle qu'elle a été publiée par la Free Software Foundation; soit la version 3 de la licence, soit (comme vous le souhaitez) toute version ultérieure.

Copies de sauvegarde est distribué dans l'espoir qu'il sera utile, mais SANS LA MOINDRE GARANTIE; pas même la garantie implicite de COMMERCIABILITE ou d'ADEQUATION A UN BUT PARTICULIER.
Voir la GNU General Public License pour plus de détails.

Vous devriez avoir reçu une copie de la GNU General Public License en même temps que ce programme; sinon, merci d'écrire à la Free Software Foundation, Inc, 59 Temple Place, Suite 330, Boston, MA02111-1307 USA.*/

#include <stdio.h>
#include "Utilitaire.h"
#include "Fichier.h"

int main (int argc,char *argv[])
{
    DIR* doss;   //Déclaration de variable de type répertoire
    FILE* liste;
    FILE* save;
    char chaine[255];
    char chaine2[255];
    char cmdsys[255];
    char nomfichier[255];
    char chfunc[255];
    int i;
    #ifdef WIN32    /*win*/
        system("title Copies de sauvegardes");
    #else /*linux*/
        startxterm (argc,argv,"Copies de sauvegardes","07");
    #endif
    puts("\t\t     Gestionnaire des copies de sauvegardes");
    liste = ouvre_fichier("Liste dossiers.txt","r");
    save = ouvre_fichier("Chemins de sauvegardes.txt","r");
    while(fgets(chaine,255,liste) != NULL)  /*Evite de répéter la dernière ligne*/
    {
        rewind(save);
        Efface_n(chaine);     /*Retire le \n*/
        for(i=0;i<strlen(chaine);i++)
        {
            nomfichier[i] = chaine[i];
            if(chaine[i] == '\\' || chaine[i] == '/' || chaine[i] == ':')
                nomfichier[i] = '_';        /*Crée nomfichier à partir du chemin en remplaçant les \, / et : par _*/
        }
        nomfichier[i] = '\0';   /*Termine la chaine*/
        printf("\n>>> %s\n", acc(chaine,chfunc));
        if ((doss = opendir(chaine)) != NULL)    //Test l'accessibilité du dossier
        {
            while(fgets(chaine2,255,save) != NULL)  /*Evite de répéter la dernière ligne*/
            { /*Boucle sur les différents chemin de sauvegardes*/
                Efface_n(chaine2);     /*Retire le \n*/
                #ifdef WIN32    /*win*/
                    sprintf(cmdsys,"rmdir /S /Q \"%s\\%s old\"", chaine2, nomfichier);   //Construit la commande de suppression du fichier old (win)
                #else /*linux*/
                    sprintf(cmdsys,"rm -r \"%s\\%s old\"", chaine2, nomfichier);   //Construit la commande de suppression du fichier old (linux)
                #endif
                changeslash(cmdsys);    //Inerse les slash pour linux (le cas échéant)
                system(cmdsys); /*Supprime le dossier old*/
                #ifdef WIN32    /*win*/
                    sprintf(cmdsys,"rename \"%s\\%s\" \"%s old\"", chaine2, nomfichier, nomfichier);    /*Construit la commande pour renommer (win)*/
                #else /*linux*/
                    sprintf(cmdsys,"mv \"%s\\%s\" \"%s old\"", chaine2, nomfichier, nomfichier);    /*Construit la commande pour renommer (linux)*/
                #endif
                changeslash(cmdsys);    //Inerse les slash pour linux (le cas échéant)
                system(cmdsys); /*Renome le dossier en old*/
                sprintf(cmdsys,"mkdir \"%s\\%s", chaine2, nomfichier);  /*Construit la commande de création de repértoire*/
                changeslash(cmdsys);    //Inerse les slash pour linux (le cas échéant)
                system(cmdsys); /*Créer le fichier*/
                #ifdef WIN32    /*win*/
                    sprintf(cmdsys,"xcopy \"%s\" \"%s\\%s\" /E /I /H /K", chaine, chaine2, nomfichier);    /*Construit la commande de copy (win)*/
                #else /*linux*/
                    sprintf(cmdsys,"cp -r \"%s\" \"%s\\%s\"", chaine, chaine2, nomfichier);    /*Construit la commande de copy (linux)*/
                #endif
                changeslash(cmdsys);    //Inerse les slash pour linux (le cas échéant)
                system(cmdsys); /*Copie le dossier*/
            }
        }
        else    /*Le cd à renvoyé une erreur*/
            puts("Le dossier est inaccessible !!!");
    }
    fclose(liste);
    return 0;
}
